
// --------------------------------- VNX_switch.h -------------------------------------------
//
//	Include file for LabBrick RF Switch API
//
// (c) 2008 - 2012 by Vaunix Corporation, all rights reserved
//
//	RD Version 1.0
//
//  RD 8-31-12 version for Microsoft C __cdecl calling convention
//
//	RD 10-1-12 version for Lab Brick RF Switch products

#define VNX_SWITCH_API __declspec(dllimport) 

#ifdef __cplusplus
extern "C" {
#endif

// ----------- Global Equates ------------
#define MAXDEVICES 64
#define MAX_MODELNAME 32
#define MAX_PATTERN_LENGTH 4
#define MAX_HOLD_TIME 100000000

// ----------- Data Types ----------------

#define DEVID unsigned int

// ----------- Mode Bit Masks ------------

#define MODE_RFON	0x00000010			// bit is 1 for RF on, 0 if RF is off (unused in RF switches)
#define MODE_INTREF	0x00000020			// bit is 1 for internal osc., 0 for external reference (unused in RF switches)
#define MODE_SWEEP	0x0000000F			// bottom 4 bits are used to keep the pattern control bits				
#define MODE_PWMON	0x00000100			// we keep a copy of the PWM control bits here, 1 for int PWM on
#define MODE_EXTPWM	0x00000200			// 1 for ext. PWM and switch control inputs enabled
#define PWM_MASK	0x00000300

// ----------- Pattern Type Masks --------

#define SWPAT_REPEAT		0x02		// MASK: bit = 1 for repeating pattern operation
#define SWPAT_ONCE			0x01		// MASK: bit = 1 for single repetition of the pattern

// ----------- Command Equates -----------

// Status returns for commands
#define LVSTATUS int

#define STATUS_OK 0
#define BAD_PARAMETER 0x80010000			// out of range input -- argument outside min/max etc.
#define BAD_HID_IO    0x80020000			// low level I/O failure, usually a USB or driver problem
#define DEVICE_NOT_READY 0x80030000			// device isn't open, no handle, etc.
#define STATUS_ERROR 0x80000000				// mask to test if we got an error

#define F_INVALID_DEVID		-1.0			// for functions that return a float
#define F_DEVICE_NOT_READY	-3.0


// Status returns for DevStatus

#define INVALID_DEVID 0x80000000			// MSB is set if the device ID is invalid
#define DEV_CONNECTED 0x00000001			// LSB is set if a device is connected
#define DEV_OPENED	  0x00000002			// set if the device is opened
#define SWP_ACTIVE	  0x00000004			// set if the device is running a pattern
#define SWP_UP		  0x00000008			// unused
#define SWP_REPEAT	  0x00000010			// set if the device is repeating a pattern


VNX_SWITCH_API void fnLSW_SetTestMode(bool testmode);
VNX_SWITCH_API int fnLSW_GetNumDevices();
VNX_SWITCH_API int fnLSW_GetDevInfo(DEVID *ActiveDevices);
VNX_SWITCH_API int fnLSW_GetModelName(DEVID deviceID, char *ModelName);
VNX_SWITCH_API int fnLSW_InitDevice(DEVID deviceID);
VNX_SWITCH_API int fnLSW_CloseDevice(DEVID deviceID);
VNX_SWITCH_API int fnLSW_GetSerialNumber(DEVID deviceID);

VNX_SWITCH_API int fnLSW_GetDeviceStatus(DEVID deviceID);

VNX_SWITCH_API int fnLSW_GetNumSwitches(DEVID deviceID);
VNX_SWITCH_API LVSTATUS fnLSW_SetSwitch(DEVID deviceID, int inputselect);
VNX_SWITCH_API int fnLSW_GetActiveSwitch(DEVID deviceID);
VNX_SWITCH_API int fnLSW_GetSwitchSetting(DEVID deviceID);
VNX_SWITCH_API LVSTATUS fnLSW_SetUseExternalControl(DEVID deviceID, bool external);
VNX_SWITCH_API int fnLSW_GetUseExternalControl(DEVID deviceID);

VNX_SWITCH_API LVSTATUS fnLSW_SetPulseOnTime(DEVID deviceID, float pulseontime);
VNX_SWITCH_API LVSTATUS fnLSW_SetPulseOffTime(DEVID deviceID, float pulseofftime);
VNX_SWITCH_API LVSTATUS fnLSW_EnableInternalPulseMod(DEVID deviceID, bool on);
VNX_SWITCH_API LVSTATUS fnLSW_SetFastPulsedOutput(DEVID deviceID, float pulseontime, float pulsereptime, bool on);
VNX_SWITCH_API float fnLSW_GetPulseOnTime(DEVID deviceID);
VNX_SWITCH_API float fnLSW_GetPulseOffTime(DEVID deviceID);
VNX_SWITCH_API int fnLSW_GetPulseMode(DEVID deviceID);
VNX_SWITCH_API int fnLSW_GetHasFastPulseMode(DEVID deviceID);

VNX_SWITCH_API LVSTATUS fnLSW_SetPattern(DEVID deviceID, int num_entries, int sw_select[], int holdtime[]);
VNX_SWITCH_API LVSTATUS fnLSW_SetPatternEntry(DEVID deviceID, int sw_select, int holdtime, int index, bool last_entry);
VNX_SWITCH_API LVSTATUS fnLSW_StartPattern(DEVID deviceID, bool go);
VNX_SWITCH_API LVSTATUS fnLSW_SetPatternType(DEVID deviceID, bool continuous );
VNX_SWITCH_API int fnLSW_GetPatternEntrySwitch(DEVID deviceID, int index);
VNX_SWITCH_API int fnLSW_GetPatternEntryTime(DEVID deviceID, int index);
VNX_SWITCH_API int fnLSW_GetPatternType(DEVID deviceID);
VNX_SWITCH_API int fnLSW_GetPatternLength(DEVID deviceID);

VNX_SWITCH_API LVSTATUS fnLSW_SaveSettings(DEVID deviceID);

#ifdef __cplusplus
	}
#endif